import pickle
import random
import numpy as np
import symmetries
from inspect import getmembers, isfunction
import itertools
from z3 import *


n_meas = 16

songs = pickle.load(open("pickles/meas" + str(n_meas) + ".pcl", "rb"))
all_rewards_tot = []
all_rewards_vec = []
all_rewards_mat = []

rewards = {}
best_rewards = []
#this creates a dict of functions from the symmetries file
# I don't think symhelpers methods are included in getmembers, so I removed the check for mod12Same
functions_list = [o for o in getmembers(symmetries) if isfunction(o[1])]
functions_name_list = [o[0] for o in functions_list]
print(functions_name_list, len(functions_name_list))


# Weighting
functions_name_list_important = ['hasSameRhythm', 'hasAddOnePitchSymmetry', 'hasIntervalSymmetry', 'hasSameContour', 'hasSamePitches', 'hasAddOneRhythmSymmetry']

for (name, func) in functions_list:
    if name in functions_name_list_important:
        rewards[name] = 2
    else:
        rewards[name] = 1
        

for z in range(len(songs)):
    song = songs[z]

    if len(song) < n_meas:
        continue
    else:
        song = song[:n_meas]

    tot_rewards = [[(0) for (i) in range(len(song))]  for j in range(len(song))]
    rewards_names = [[[] for (i) in range(len(song))]  for j in range(len(song))]
    rewards_mat = np.zeros((len(song), len(song), len(rewards)))

    for i in range(len(song)):
        for j in range(len(song)):
            if i == j:
                tot_rewards[i][j] += (sum(rewards.values()))
                rewards_names[i][j] = list(rewards.keys())
                rewards_mat[i][j] = np.ones(len(rewards))
            else:
                meas_i = song[i]
                meas_j = song[j]
                #run through all possible symmetries, get total score
                for (name, func) in functions_list:
                    if name != "mod12Same":
                        if func(meas_i, meas_j):
                            tot_rewards[i][j] += (rewards[name])
                            rewards_names[i][j].append(name)
                            rewards_mat[i,j,functions_name_list.index(name)] = 1
        best_reward_j = max([tot_rewards[i][k] for k in range(len(song)) if k != i])
        best_rewards.append(best_reward_j)

    #for i in range(len(song)):
    #    for j in range(len(song)):
    #        tot_rewards[i][j] = (sum(rewards.values())) - tot_rewards[i][j]
    all_rewards_vec.append(rewards_names)
    all_rewards_tot.append(tot_rewards)
    all_rewards_mat.append(rewards_mat)


pickle.dump(all_rewards_vec, open("pickles/all_rewards_vec" + str(n_meas) + ".pcl", "wb"))
pickle.dump(all_rewards_tot, open("pickles/all_rewards_tot" + str(n_meas) + ".pcl", "wb"))
pickle.dump(all_rewards_mat, open("pickles/all_rewards_mat" + str(n_meas) + ".pcl", "wb"))

